/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.datarule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.datarule.builder.DataRuleBuilderUtil;
import com.xforceplus.ultraman.bocp.metadata.datarule.enums.DataRuleStatus;
import com.xforceplus.ultraman.bocp.metadata.datarule.mapstruct.BoDataRuleDetailStructMapper;
import com.xforceplus.ultraman.bocp.metadata.datarule.mapstruct.BoDataRuleStructMapper;
import com.xforceplus.ultraman.bocp.metadata.datarule.service.IBoDataRuleExService;
import com.xforceplus.ultraman.bocp.metadata.datarule.validator.DataRuleValidator;
import com.xforceplus.ultraman.bocp.metadata.datarule.vo.DataRuleDetailVo;
import com.xforceplus.ultraman.bocp.metadata.datarule.vo.DataRuleVo;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.validator.ValidateResponse;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRuleDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.BoDataRuleMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoDataRuleDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoDataRuleService;
import com.xforceplus.ultraman.datarule.domain.enums.EntityActionType;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DataRuleDetailRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DataRuleRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BoDataRuleExServiceImpl
implements IBoDataRuleExService {
    @Autowired
    private DataRuleValidator dataRuleValidator;
    @Autowired
    private IBoDataRuleService boDataRuleService;
    @Autowired
    private BoDataRuleMapper boDataRuleMapper;
    @Autowired
    private IBoDataRuleDetailService boDataRuleDetailService;
    @Autowired
    private BoRepository boRepository;
    @Autowired
    private DataRuleRepository dataRuleRepository;
    @Autowired
    private DataRuleDetailRepository dataRuleDetailRepository;

    @Override
    public List<DataRuleVo> getDataRuleVosByBoId(Long appId, Long boId) {
        List dataRules = this.dataRuleRepository.getDefaultDataRules(appId, boId);
        return dataRules.stream().map(dataRule -> {
            List dataRuleDetails = this.dataRuleDetailRepository.getDefaultDetails(dataRule.getId());
            return DataRuleBuilderUtil.getDataRuleVo(dataRule, dataRuleDetails);
        }).collect(Collectors.toList());
    }

    @Override
    public List<DataRuleVo> getDataRuleVosByBoId(Long appId, Long boId, String tenantCode) {
        List dataRules = this.dataRuleRepository.getDefaultDataRules(appId, boId, tenantCode);
        return dataRules.stream().map(dataRule -> {
            List dataRuleDetails = this.dataRuleDetailRepository.getDefaultDetails(dataRule.getId());
            return DataRuleBuilderUtil.getDataRuleVo(dataRule, dataRuleDetails);
        }).collect(Collectors.toList());
    }

    @Override
    public ServiceResponse getDataRuleVo(Long appId, Long dataRuleId) {
        BoDataRule dataRule = this.dataRuleRepository.getDefaultDataRuleWithValidate(dataRuleId, true);
        List dataRuleDetails = this.dataRuleDetailRepository.getDefaultDetails(dataRuleId);
        return ServiceResponse.success((String)"", (Object)DataRuleBuilderUtil.getDataRuleVo(dataRule, dataRuleDetails));
    }

    @Override
    public ServiceResponse saveDataRule(DataRuleVo dataRuleVo) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateCreateDefault(dataRuleVo);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        BoDataRule boDataRule = BoDataRuleStructMapper.MAPPER.toEntity(dataRuleVo);
        boDataRule.setId(null);
        boDataRule.setUniqueId(null);
        boDataRule.setPublishFlag(PublishFlag.UNPUBLISHED.code());
        boDataRule.setVersion("0.0.0");
        boDataRule.setStatus(DataRuleStatus.fromCode((String)dataRuleVo.getStatus()).code());
        if (StringUtils.isNotEmpty((CharSequence)dataRuleVo.getTenantCode())) {
            Optional tenantBoOptl = this.boRepository.getBo(dataRuleVo.getBoId());
            if (!tenantBoOptl.isPresent()) {
                return ServiceResponse.fail((String)"\u627e\u4e0d\u5230\u79df\u6237\u5b9a\u5236\u5bf9\u8c61");
            }
            boDataRule.setRefBoId(((Bo)tenantBoOptl.get()).getRefBoId());
        }
        this.boDataRuleService.save((Object)boDataRule);
        ArrayList dataRuleDetails = Lists.newArrayList();
        Optional.ofNullable(dataRuleVo.getDetails()).ifPresent(details -> details.keySet().forEach(key -> {
            BoDataRuleDetail dataRuleDetail = BoDataRuleDetailStructMapper.MAPPER.toDetail(dataRuleVo.getDetails().get(key));
            dataRuleDetail.setId(null);
            dataRuleDetail.setEntityAction(key);
            dataRuleDetail.setDataRuleId(boDataRule.getId());
            dataRuleDetail.setStatus(Optional.ofNullable(dataRuleDetail.getStatus()).orElse(DataRuleStatus.DISABLED.code()));
            dataRuleDetails.add(dataRuleDetail);
        }));
        if (!dataRuleDetails.isEmpty()) {
            this.boDataRuleDetailService.saveBatch((Collection)dataRuleDetails);
        }
        return ServiceResponse.success();
    }

    @Override
    public ServiceResponse updateDataRule(DataRuleVo dataRuleVo) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateUpdateDefault(dataRuleVo);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        BoDataRule dataRule = (BoDataRule)validateResponse.getData();
        BoDataRuleStructMapper.MAPPER.updateEntityFromVo(dataRuleVo, dataRule);
        this.boDataRuleMapper.alwaysUpdateSomeColumnById((Object)dataRule);
        Map<String, DataRuleDetailVo> dataRuleDetailVoMap = Optional.ofNullable(dataRuleVo.getDetails()).orElse(Maps.newHashMap());
        Map dataRuleDetailMap = this.dataRuleDetailRepository.getDefaultDetails(dataRuleVo.getId()).stream().collect(Collectors.toMap(BoDataRuleDetail::getEntityAction, Function.identity()));
        Stream.of(EntityActionType.values()).forEach(actionType -> {
            if (dataRuleDetailVoMap.containsKey(actionType.code()) && dataRuleDetailMap.containsKey(actionType.code())) {
                BoDataRuleDetailStructMapper.MAPPER.updateDetail((DataRuleDetailVo)dataRuleDetailVoMap.get(actionType.code()), (BoDataRuleDetail)dataRuleDetailMap.get(actionType.code()));
            } else if (dataRuleDetailVoMap.containsKey(actionType.code()) && !dataRuleDetailMap.containsKey(actionType.code())) {
                BoDataRuleDetail dataRuleDetail = BoDataRuleDetailStructMapper.MAPPER.toDetail((DataRuleDetailVo)dataRuleDetailVoMap.get(actionType.code()));
                dataRuleDetail.setDataRuleId(dataRule.getId());
                dataRuleDetail.setStatus(Optional.ofNullable(dataRuleDetail.getStatus()).orElse(DataRuleStatus.DISABLED.code()));
                dataRuleDetailMap.put(actionType.code(), dataRuleDetail);
            } else if (!dataRuleDetailVoMap.containsKey(actionType.code()) && dataRuleDetailMap.containsKey(actionType.code())) {
                BoDataRuleDetail dataRuleDetail = (BoDataRuleDetail)dataRuleDetailMap.get(actionType.code());
                dataRuleDetail.setStatus(DataRuleStatus.DISABLED.code());
            }
        });
        dataRuleDetailMap.values().forEach(o -> {
            if (null == o.getId()) {
                this.boDataRuleDetailService.save(o);
            } else {
                this.boDataRuleDetailService.alwaysUpdateSomeColumnById(o);
            }
        });
        return ServiceResponse.success();
    }

    @Override
    public ServiceResponse removeDataRule(Long appId, Long dataRuleId) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateDefaultExist(appId, dataRuleId);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        this.boDataRuleService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(BoDataRule::getDeleteFlag, (Object)"1")).eq(BoDataRule::getAppId, (Object)appId)).eq(BoDataRule::getId, (Object)dataRuleId)).set(BoDataRule::getDeleteFlag, (Object)"0"));
        this.boDataRuleDetailService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(BoDataRuleDetail::getDeleteFlag, (Object)"1")).eq(BoDataRuleDetail::getDataRuleId, (Object)dataRuleId)).set(BoDataRuleDetail::getDeleteFlag, (Object)"0"));
        return ServiceResponse.success();
    }

    @Override
    public ServiceResponse removeDataRule(Long appId, Long dataRuleId, EntityActionType actionType) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateDefaultExist(appId, dataRuleId);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        this.boDataRuleService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(BoDataRule::getDeleteFlag, (Object)"1")).eq(BoDataRule::getAppId, (Object)appId)).eq(BoDataRule::getId, (Object)dataRuleId)).set(BoDataRule::getDeleteFlag, (Object)"0"));
        this.boDataRuleDetailService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(BoDataRuleDetail::getDeleteFlag, (Object)"1")).eq(BoDataRuleDetail::getDataRuleId, (Object)dataRuleId)).eq(BoDataRuleDetail::getEntityAction, (Object)actionType.code())).set(BoDataRuleDetail::getDeleteFlag, (Object)"0"));
        return ServiceResponse.success();
    }

    @Override
    public ServiceResponse updateStatus(Long appId, Long dataRuleId, String status) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateDefaultExist(appId, dataRuleId);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        BoDataRule dataRule = (BoDataRule)validateResponse.getData();
        dataRule.setStatus(DataRuleStatus.fromCode((String)status).code());
        return this.boDataRuleService.updateById((Object)dataRule) ? ServiceResponse.success() : ServiceResponse.fail((String)"\u66f4\u65b0\u5931\u8d25");
    }
}

