/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.datarule.validator;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.metadata.datarule.enums.DataRuleOp;
import com.xforceplus.ultraman.bocp.metadata.datarule.enums.DataRuleRowType;
import com.xforceplus.ultraman.bocp.metadata.datarule.enums.DataRuleType;
import com.xforceplus.ultraman.bocp.metadata.datarule.vo.DataRuleDetailVo;
import com.xforceplus.ultraman.bocp.metadata.datarule.vo.DataRuleVo;
import com.xforceplus.ultraman.bocp.metadata.exception.ValidateException;
import com.xforceplus.ultraman.bocp.metadata.validator.AppValidator;
import com.xforceplus.ultraman.bocp.metadata.validator.DeployEnvValidator;
import com.xforceplus.ultraman.bocp.metadata.validator.ValidateResponse;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.DataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.DataRuleDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDataRuleService;
import com.xforceplus.ultraman.datarule.domain.enums.EntityActionType;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DataRuleRepository;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataRuleValidator {
    public static final int ENTITY_ACTION_LIMIT = 4;
    @Autowired
    private AppValidator appValidator;
    @Autowired
    private DeployEnvValidator deployEnvValidator;
    @Autowired
    private IDataRuleService dataRuleService;
    @Autowired
    private DataRuleRepository dataRuleRepository;

    public ValidateResponse validateCreateDefault(DataRuleVo dataRuleVo) {
        try {
            ValidateResponse validateResponse = this.appValidator.validateExist(dataRuleVo.getAppId());
            if (validateResponse.failed()) {
                return validateResponse;
            }
            ValidateResponse drValidateResponse = this.validateDefaultNotExist(dataRuleVo);
            if (drValidateResponse.failed()) {
                return drValidateResponse;
            }
            Optional.ofNullable(dataRuleVo.getDetails()).ifPresent(detailMap -> detailMap.keySet().forEach(key -> {
                DataRuleDetailVo dataRuleDetailVo = (DataRuleDetailVo)detailMap.get(key);
                this.validateDataRuleDetail(dataRuleDetailVo);
            }));
        }
        catch (ValidateException e) {
            return ValidateResponse.failed((String)e.getMessage());
        }
        return ValidateResponse.success();
    }

    public ValidateResponse validateUpdateDefault(DataRuleVo boDataRule) {
        try {
            ValidateResponse validateResponse = this.appValidator.validateExist(boDataRule.getAppId());
            if (validateResponse.failed()) {
                return validateResponse;
            }
            return this.validateDefaultExist(boDataRule.getAppId(), boDataRule.getId());
        }
        catch (ValidateException e) {
            return ValidateResponse.failed((String)e.getMessage());
        }
    }

    public ValidateResponse validateDefaultNotExist(DataRuleVo dataRule) {
        List boDataRules = this.dataRuleRepository.getDefaultDataRules(dataRule.getAppId(), dataRule.getBoId());
        return boDataRules.isEmpty() ? ValidateResponse.success() : ValidateResponse.failed((String)"\u9ed8\u8ba4\u6570\u636e\u6743\u9650\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
    }

    public ValidateResponse validateDefaultExist(Long appId, Long dataRuleId) {
        BoDataRule dataRule = this.dataRuleRepository.getDefaultDataRule(appId, dataRuleId).orElse(null);
        if (dataRule == null) {
            return ValidateResponse.failed((String)"\u627e\u4e0d\u5230\u6570\u636e\u6743\u9650\u89c4\u5219");
        }
        return ValidateResponse.success((Object)dataRule);
    }

    public ValidateResponse validateCreateCustom(DataRuleVo dataRuleVo) {
        try {
            ValidateResponse validateResponse = this.appValidator.validateExist(dataRuleVo.getAppId());
            if (validateResponse.failed()) {
                return validateResponse;
            }
            this.validateType(dataRuleVo.getType());
            this.validateDefaultRuleOp(dataRuleVo.getDefaultRuleOp());
            Optional.ofNullable(dataRuleVo.getDetails()).ifPresent(detailMap -> detailMap.keySet().forEach(key -> {
                DataRuleDetailVo dataRuleDetailVo = (DataRuleDetailVo)detailMap.get(key);
                this.validateDataRuleDetail(dataRuleDetailVo);
            }));
        }
        catch (ValidateException e) {
            return ValidateResponse.failed((String)e.getMessage());
        }
        return ValidateResponse.success();
    }

    public ValidateResponse validateUpdateCustom(DataRuleVo dataRule) {
        try {
            ValidateResponse validateResponse = this.appValidator.validateExist(dataRule.getAppId());
            if (validateResponse.failed()) {
                return validateResponse;
            }
            return this.validateCustomExist(dataRule.getAppId(), dataRule.getEnvId(), dataRule.getId());
        }
        catch (ValidateException e) {
            return ValidateResponse.failed((String)e.getMessage());
        }
    }

    public ValidateResponse validateCustomExist(Long appId, Long envId, Long dataRuleId) {
        DataRule dataRule;
        LambdaQueryWrapper dataRuleWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DataRule::getDeleteFlag, (Object)"1")).eq(DataRule::getAppId, (Object)appId)).eq(DataRule::getId, (Object)dataRuleId);
        ValidateResponse validateResponse = this.deployEnvValidator.validateExist(envId);
        if (validateResponse.isSuccess()) {
            dataRuleWrapper.eq(DataRule::getEnvId, (Object)envId);
        }
        if ((dataRule = (DataRule)this.dataRuleService.getOne((Wrapper)dataRuleWrapper, false)) == null) {
            return ValidateResponse.failed((String)"\u627e\u4e0d\u5230\u6570\u636e\u6743\u9650\u89c4\u5219");
        }
        return ValidateResponse.success((Object)dataRule);
    }

    public void validateDefaultRuleOp(String defaultRuleOp) {
        DataRuleOp defaultDataRuleOp = DataRuleOp.fromCode((String)defaultRuleOp);
        if (null == defaultDataRuleOp) {
            throw new ValidateException("\u9ed8\u8ba4\u6570\u636e\u6743\u9650\u89c4\u5219\u5904\u7406\u65b9\u5f0f\u4e0d\u5b58\u5728");
        }
    }

    public void validateDataRuleDetail(DataRuleDetailVo dataRuleDetailVo) {
        this.validateRowRuleType(dataRuleDetailVo.getRowRuleType(), dataRuleDetailVo.getRowField());
    }

    public void validateType(String type) {
        DataRuleType dataRuleType = DataRuleType.fromCode((String)type);
        if (null == dataRuleType) {
            throw new ValidateException("\u6570\u636e\u6743\u9650\u89c4\u5219\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
    }

    public void validateRowRuleType(String rowRuleType, String rowField) {
        if ((DataRuleRowType.CURRENT_ORG_IDS.code().equals(rowRuleType) || DataRuleRowType.CURRENT_ORG_CODES.code().equals(rowRuleType)) && StringUtils.isEmpty((CharSequence)rowField)) {
            throw new ValidateException(String.format("\u6570\u636e\u8303\u56f4\u3010%s\u3011\u5bf9\u5e94\u5b57\u6bb5\u7f3a\u5931", rowRuleType));
        }
    }

    public ValidateResponse validateCustomExist(Long appId, Long dataRuleId) {
        LambdaQueryWrapper dataRuleWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DataRule::getDeleteFlag, (Object)"1")).eq(DataRule::getAppId, (Object)appId)).eq(DataRule::getId, (Object)dataRuleId);
        DataRule dataRule = (DataRule)this.dataRuleService.getOne((Wrapper)dataRuleWrapper, false);
        if (dataRule == null) {
            return ValidateResponse.failed((String)"\u627e\u4e0d\u5230\u6570\u636e\u6743\u9650\u89c4\u5219");
        }
        return ValidateResponse.success((Object)dataRule);
    }

    public ValidateResponse validateEntityAction(List<DataRuleDetail> dataRuleDetails) {
        if (CollectionUtils.isNotEmpty(dataRuleDetails)) {
            if (dataRuleDetails.size() > 4) {
                return ValidateResponse.failed((String)"\u6570\u636e\u6743\u9650\u4e2d\u6709\u91cd\u590d\u7684\u64cd\u4f5c\u6743\u9650");
            }
            for (DataRuleDetail dataRuleDetail : dataRuleDetails) {
                if (null != EntityActionType.fromCode((String)dataRuleDetail.getEntityAction())) continue;
                return ValidateResponse.failed((String)("\u6570\u636e\u6743\u9650\u4e2d\u6709\u975e\u6cd5\u7684\u64cd\u4f5c\u6743\u9650\uff1a" + dataRuleDetail.getEntityAction()));
            }
        }
        return ValidateResponse.success();
    }
}

