/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.datarule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.datarule.builder.DataRuleBuilderUtil;
import com.xforceplus.ultraman.bocp.metadata.datarule.enums.DataRuleStatus;
import com.xforceplus.ultraman.bocp.metadata.datarule.mapstruct.DataRuleDetailStructMapper;
import com.xforceplus.ultraman.bocp.metadata.datarule.mapstruct.DataRuleStructMapper;
import com.xforceplus.ultraman.bocp.metadata.datarule.service.IDataRuleExService;
import com.xforceplus.ultraman.bocp.metadata.datarule.validator.DataRuleValidator;
import com.xforceplus.ultraman.bocp.metadata.datarule.vo.DataRuleDetailVo;
import com.xforceplus.ultraman.bocp.metadata.datarule.vo.DataRuleVo;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.validator.ValidateResponse;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.DataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.DataRuleDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.DataRuleMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDataRuleDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDataRuleService;
import com.xforceplus.ultraman.datarule.domain.enums.EntityActionType;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DataRuleDetailRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DataRuleRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataRuleExServiceImpl
implements IDataRuleExService {
    @Autowired
    private IDataRuleService dataRuleService;
    @Autowired
    private IDataRuleDetailService dataRuleDetailService;
    @Autowired
    private DataRuleMapper dataRuleMapper;
    @Autowired
    private DataRuleValidator dataRuleValidator;
    @Autowired
    private DataRuleRepository dataRuleRepository;
    @Autowired
    private DataRuleDetailRepository dataRuleDetailRepository;

    @Override
    public ServiceResponse getDataRuleVo(Long appId, Long dataRuleId) {
        DataRule dataRule = this.dataRuleRepository.getCustomDataRule(appId, dataRuleId).orElse(null);
        List dataRuleDetails = this.dataRuleDetailRepository.getCustomDetails(dataRuleId);
        return ServiceResponse.success((String)"", (Object)DataRuleBuilderUtil.getDataRuleVo(dataRule, dataRuleDetails));
    }

    @Override
    public ServiceResponse saveDataRule(DataRuleVo dataRuleVo) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateCreateCustom(dataRuleVo);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        DataRule dataRule = DataRuleStructMapper.MAPPER.toEntity(dataRuleVo);
        dataRule.setId(null);
        dataRule.setUniqueId(null);
        dataRule.setVersion("0.0.0");
        dataRule.setStatus(DataRuleStatus.ENABLED.code());
        this.dataRuleService.save((Object)dataRule);
        ArrayList dataRuleDetails = Lists.newArrayList();
        Optional.ofNullable(dataRuleVo.getDetails()).ifPresent(details -> details.keySet().forEach(key -> {
            DataRuleDetail dataRuleDetail = DataRuleDetailStructMapper.MAPPER.toDetail(dataRuleVo.getDetails().get(key));
            dataRuleDetail.setEntityAction(key);
            dataRuleDetail.setDataRuleId(dataRule.getId());
            dataRuleDetail.setStatus(Optional.ofNullable(dataRuleDetail.getStatus()).orElse(DataRuleStatus.DISABLED.code()));
            dataRuleDetails.add(dataRuleDetail);
        }));
        if (!dataRuleDetails.isEmpty()) {
            this.dataRuleDetailService.saveBatch((Collection)dataRuleDetails);
        }
        return ServiceResponse.success();
    }

    @Override
    public ServiceResponse updateDataRule(DataRuleVo updateData) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateUpdateCustom(updateData);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        DataRule dataRule = (DataRule)validateResponse.getData();
        DataRuleStructMapper.MAPPER.updateEntity(updateData, dataRule);
        this.dataRuleMapper.alwaysUpdateSomeColumnById((Object)dataRule);
        Map<String, DataRuleDetailVo> dataRuleDetailVoMap = Optional.ofNullable(updateData.getDetails()).orElse(Maps.newHashMap());
        Map dataRuleDetailMap = this.dataRuleDetailRepository.getCustomDetails(updateData.getId()).stream().collect(Collectors.toMap(DataRuleDetail::getEntityAction, Function.identity()));
        Stream.of(EntityActionType.values()).forEach(actionType -> {
            if (dataRuleDetailVoMap.containsKey(actionType.code()) && dataRuleDetailMap.containsKey(actionType.code())) {
                DataRuleDetailStructMapper.MAPPER.updateDetail((DataRuleDetailVo)dataRuleDetailVoMap.get(actionType.code()), (DataRuleDetail)dataRuleDetailMap.get(actionType.code()));
            } else if (dataRuleDetailVoMap.containsKey(actionType.code()) && !dataRuleDetailMap.containsKey(actionType.code())) {
                DataRuleDetail dataRuleDetail = DataRuleDetailStructMapper.MAPPER.toDetail((DataRuleDetailVo)dataRuleDetailVoMap.get(actionType.code()));
                dataRuleDetail.setDataRuleId(dataRule.getId());
                dataRuleDetail.setStatus(Optional.ofNullable(dataRuleDetail.getStatus()).orElse(DataRuleStatus.DISABLED.code()));
                dataRuleDetailMap.put(actionType.code(), dataRuleDetail);
            } else if (!dataRuleDetailVoMap.containsKey(actionType.code()) && dataRuleDetailMap.containsKey(actionType.code())) {
                DataRuleDetail dataRuleDetail = (DataRuleDetail)dataRuleDetailMap.get(actionType.code());
                dataRuleDetail.setStatus(DataRuleStatus.DISABLED.code());
            }
        });
        dataRuleDetailMap.values().forEach(o -> {
            if (null == o.getId()) {
                this.dataRuleDetailService.save(o);
            } else {
                this.dataRuleDetailService.alwaysUpdateSomeColumnById(o);
            }
        });
        return ServiceResponse.success();
    }

    @Override
    public ServiceResponse removeDataRule(Long appId, Long dataRuleId) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateCustomExist(appId, null, dataRuleId);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        this.dataRuleService.update((Object)new DataRule(), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(DataRule::getDeleteFlag, (Object)"1")).eq(DataRule::getAppId, (Object)appId)).eq(DataRule::getId, (Object)dataRuleId)).set(DataRule::getDeleteFlag, (Object)"0"));
        this.dataRuleDetailService.update((Object)new DataRuleDetail(), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(DataRuleDetail::getDeleteFlag, (Object)"1")).eq(DataRuleDetail::getDataRuleId, (Object)dataRuleId)).set(DataRuleDetail::getDeleteFlag, (Object)"0"));
        return ServiceResponse.success();
    }

    @Override
    public ServiceResponse removeDataRule(Long appId, Long dataRuleId, EntityActionType actionType) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateCustomExist(appId, null, dataRuleId);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        this.dataRuleService.update((Object)new DataRule(), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(DataRule::getDeleteFlag, (Object)"1")).eq(DataRule::getAppId, (Object)appId)).eq(DataRule::getId, (Object)dataRuleId)).set(DataRule::getDeleteFlag, (Object)"0"));
        this.dataRuleDetailService.update((Object)new DataRuleDetail(), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(DataRuleDetail::getDeleteFlag, (Object)"1")).eq(DataRuleDetail::getDataRuleId, (Object)dataRuleId)).eq(DataRuleDetail::getEntityAction, (Object)actionType.code())).set(DataRuleDetail::getDeleteFlag, (Object)"0"));
        return ServiceResponse.success();
    }

    @Override
    public ServiceResponse updateTenantScope(Long appId, Long dataRuleId, String tenantScope) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateCustomExist(appId, dataRuleId);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        DataRule dataRule = (DataRule)validateResponse.getData();
        dataRule.setId(dataRuleId).setTenantScope(tenantScope);
        this.dataRuleMapper.alwaysUpdateSomeColumnById((Object)dataRule);
        return ServiceResponse.success();
    }

    @Override
    public ServiceResponse updateStatus(Long appId, Long dataRuleId, String status) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateCustomExist(appId, dataRuleId);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        DataRule dataRule = (DataRule)validateResponse.getData();
        dataRule.setStatus(DataRuleStatus.fromCode((String)status).code());
        this.dataRuleService.updateById((Object)dataRule);
        return ServiceResponse.success();
    }
}

