package com.xforceplus.ultraman.bocp.metadata.apis.errorcode;

/**
 * desc :
 * name : ErrorCode
 *
 * @author : xujia
 * date : 2020/5/11
 * @since : 1.8
 */
public enum ErrorCode {

    //  1000X-系统内部错误类
    INIT_CONFIG_ERROR(10001, "初始化配置错误"),
    DATA_BASE_OPERATION_ERROR(10002, "数据库操作错误"),

    //  2000X-由于业务造成的通用数据库类错误
    OBJECT_NOT_RECODE(20001, "数据不存在"),
    OBJECT_NOT_EXIST(20002, "数据不存在"),

    //  错误类型300X-请求对象参数缺失
    REQUEST_PARAMS_MISSED_ERROR(30001, "请求参数缺失"),
    REQUEST_PARAMS_INVALID_ERROR(30002, "参数不合法"),

    //  错误类型4000X-对象转换错误;
    DATA_CONVERT_ERROR(40001, "对象转换错误");

    public Integer status;
    public String message;

    ErrorCode(Integer status, String message) {
        this.status = status;
        this.message = message;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

}
