package com.xforceplus.ultraman.bocp.metadata.bo.enums;

import java.util.stream.Stream;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/4/25 17:07
 * Description:
 * History:
 */
public enum BoIndexType {

    PRIMARY("primary", "业务主键"),
    UNIQUE("unique", "唯一索引"),
    COMMON("common", "普通索引");

    private String code;

    private String desc;

    BoIndexType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public static BoIndexType fromCode(String code) {
        return Stream.of(BoIndexType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
