package com.xforceplus.ultraman.bocp.metadata.bo.enums;

import java.util.stream.Stream;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 3/17/2021 6:46 PM
 * @description:
 * @history:
 */
public enum FieldDescribeType {
    NONE("0", "无"),
    PRIMARY("1", "主要说明字段"),
    SECONDARY("2", "次要说明字段");

    private String code;

    private String desc;

    FieldDescribeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() { return desc; }

    public static FieldDescribeType fromCode(String code) {
        return Stream.of(FieldDescribeType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(NONE);
    }
}
