package com.xforceplus.ultraman.bocp.metadata.bo.enums;

import java.util.stream.Stream;

/**
 * 字段类型
 *
 * @className: FieldType
 * @package: com.xforceplus.ultraman.bocp.metadata.bo.enums.enums
 * @author: wangzheng
 * @date: 2021/3/4 17:39
 */
public enum FieldType {
    UNKNOWN("", "未知"),

    BOOLEAN("boolean", "布尔型"),
    ENUM("enum", "枚举型"),
    ENUMS("enums", "多值枚举型"),
    DATETIME("timestamp", "日期"),
    LONG("long", "整型"),
    STRING("string", "字符串"),
    STRINGS("strings", "字符串集合"),
    SERIALNO("serialNo", "纯数字编号"),
    DOUBLE("double", "小数"),
    //不属于元数据字段类型
    DECIMAL("decimal", "小数"),

    //新添加两个字段类型
    FORMULA("formula", "公式"),
    DOMAINNO("domainNo", "自增编号"),
    //查找字段和聚合字段
    LOOKUP("lookup", "查找（lookup）"),
    AGGREGATION("aggregation", "聚合"),

    //新添加业务字段
    SHORTTEXT("shortText", "短文本"),
    LONGTEXT("longText", "长文本"),
    RICHTEXT("richText", "富文本"),
    URL("url", "URL"),
    PHONE("phone", "电话"),
    EMAIL("email", "邮箱"),
    ATTACHMENT("attachment", "附件"),
    AREAS("areas", "地区"),
    FILE("file", "文件"),
    IMAGE("image", "图片"),
    AMOUNT("amount", "金额"),
    PERCENTAGE("percentage", "百分比");

    private String code;

    private String desc;

    FieldType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() { return desc; }

    public static FieldType getValue(String code){
        for (FieldType fieldType : values()) {
            if (fieldType.code.equals(code)) {
                if (fieldType.code().equals("serialNo")) {
                    return LONG;
                }
                if (fieldType.code().equals("enums")) {
                    return STRINGS;
                }
                if (fieldType.code().equals("double")) {
                    return DECIMAL;
                }
                return fieldType;
            }
        }
        return UNKNOWN;
    }

    public static FieldType getTrueValue(String code) {
        return Stream.of(FieldType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(UNKNOWN);
    }
}
