package com.xforceplus.ultraman.bocp.metadata.bo.enums;

import java.util.stream.Stream;

/**
 * 字段类型
 *
 * @className: FieldType
 * @package: com.xforceplus.ultraman.bocp.metadata.bo.enums.enums
 * @author: wangzheng
 * @date: 2021/3/4 17:39
 */
public enum FieldValueType {
    UNKNOWN("", "未知"),
    SERIALNO("serialNo", "纯数字编号"),
    BOOLEAN("boolean", "布尔型"),
    DATETIME("timestamp", "日期"),
    LONG("long", "整型"),
    STRING("string", "字符串"),
    STRINGS("strings", "字符串集合"),
    DOUBLE("double", "小数");

    private String code;

    private String desc;

    FieldValueType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() { return desc; }

    public static FieldValueType getValue(String code){
        return Stream.of(FieldValueType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(UNKNOWN);
    }

}
