package com.xforceplus.ultraman.bocp.metadata.bo.enums;

import java.util.stream.Stream;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   youyifan
 * 创建时间: 4/15/2020 4:03 PM
 * 功能描述:
 * 修改历史:
 */
public enum RelationType {
    OTO("OneToOne", "对一"),
    OTM("OneToMany", "一对多"),
    MTO("ManyToOne", "对一"),
    MTM("ManyToMany", "多对多"),
    MV("MultiValues", "多值");

    String code;
    String desc;

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RelationType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static RelationType fromType(String code) {
        return Stream.of(RelationType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
