package com.xforceplus.ultraman.bocp.metadata.bo.mapstruct;

import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoIndex;
import com.xforceplus.ultraman.bocp.metadata.vo.BoIndexVo;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 10/22/2020 11:09 AM
 * @description:
 * @history:
 */
@Mapper
public interface BoIndexStructMapper {
    BoIndexStructMapper MAPPER = Mappers.getMapper(BoIndexStructMapper.class);

    BoIndexVo toVo(BoIndex boIndex);

    BoIndex toEntity(BoIndexVo boInfoVo);

    BoIndex clone(BoIndex boIndex);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "uniqueId", ignore = true)
    @Mapping(target = "createUser", ignore = true)
    @Mapping(target = "createUserName", ignore = true)
    @Mapping(target = "createTime", ignore = true)
    @Mapping(target = "updateUser", ignore = true)
    @Mapping(target = "updateUserName", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    BoIndex createUBoIndexFromSysBoIndex(BoIndex boIndex);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(target = "code", source = "code")
    @Mapping(target = "name", source = "name")
    @Mapping(target = "type", source = "type")
    @Mapping(target = "fieldCodes", source = "fieldCodes")
    @Mapping(target = "rule", source = "rule")
    @Mapping(target = "remark", source = "remark")
    void updateUBoIndexFromSysBoIndex(BoIndex sys, @MappingTarget BoIndex currentEntity);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(target = "code", source = "code")
    @Mapping(target = "name", source = "name")
    @Mapping(target = "type", source = "type")
    @Mapping(target = "fieldCodes", source = "fieldCodes")
    @Mapping(target = "rule", source = "rule")
    @Mapping(target = "remark", source = "remark")
    void recover(BoIndex vEntity, @MappingTarget BoIndex currentEntity);
}
