package com.xforceplus.ultraman.bocp.metadata.bo.mapstruct;

import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoRelationship;
import com.xforceplus.ultraman.bocp.metadata.vo.RelationshipVo;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 9/9/2020 12:10 PM
 * @description:
 * @history:
 */
@Mapper
public interface BoRelationshipStructMapper {
    BoRelationshipStructMapper MAPPER = Mappers.getMapper(BoRelationshipStructMapper.class);

    BoRelationship toEntity(RelationshipVo relationshipVo);

    RelationshipVo toVo(BoRelationship boRelationship);

    BoRelationship clone(BoRelationship boRelationship);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "uniqueId", ignore = true)
    @Mapping(target = "createUser", ignore = true)
    @Mapping(target = "createUserName", ignore = true)
    @Mapping(target = "createTime", ignore = true)
    @Mapping(target = "updateUser", ignore = true)
    @Mapping(target = "updateUserName", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    BoRelationship createUBoRelationshipFromSysBoRelationship(BoRelationship boRelationship);

    void updateEntity(BoRelationship newBoRelationship, @MappingTarget BoRelationship boRelationship);

    void updateEntityFromVo(RelationshipVo relationshipVo, @MappingTarget BoRelationship boRelationship);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(target = "relationName", source = "relationName")
    @Mapping(target = "relationCode", source = "relationCode")
    @Mapping(target = "relationType", source = "relationType")
    @Mapping(target = "boDelStrategy", source = "boDelStrategy")
    @Mapping(target = "joinDelStrategy", source = "joinDelStrategy")
    @Mapping(target = "joinDelErrtips", source = "joinDelErrtips")
    @Mapping(target = "remark", source = "remark")
    @Mapping(target = "strongFlag", source = "strongFlag")
    @Mapping(target = "bidirectionUniqueCode", source = "bidirectionUniqueCode")
    void updateUBoRelationshipFromSysBoRelationship(BoRelationship sys, @MappingTarget BoRelationship currentEntity);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(target = "relationName", source = "relationName")
    @Mapping(target = "relationCode", source = "relationCode")
    @Mapping(target = "relationType", source = "relationType")
    @Mapping(target = "boDelStrategy", source = "boDelStrategy")
    @Mapping(target = "joinDelStrategy", source = "joinDelStrategy")
    @Mapping(target = "joinDelErrtips", source = "joinDelErrtips")
    @Mapping(target = "remark", source = "remark")
    @Mapping(target = "strongFlag", source = "strongFlag")
    @Mapping(target = "bidirectionUniqueCode", source = "bidirectionUniqueCode")
    void recover(BoRelationship vEntity, @MappingTarget BoRelationship currentEntity);
}
