package com.xforceplus.ultraman.bocp.metadata.dto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import com.google.common.collect.Lists;
import java.util.List;

@Data
public class EventSubscribeRequest {

    List<SubscribeRequest> subscribeRequests;

    @Data
    public static class SubscribeRequest
    {
        /**
         * 订阅者所在的应用code
         */
        @ApiModelProperty(value = "订阅者所在的应用Id")
        private String appId;

        /**
         * 订阅者所在的应用code
         */
        @ApiModelProperty(value = "订阅者所在的应用代码")
        private String appCode;


        /**
         * 订阅者订阅的事件ID
         */
        @ApiModelProperty(value = "订阅者订阅的事件ID")
        private String eventId;
        /**
         * 订阅者订阅的事件code
         */
        @ApiModelProperty(value = "订阅者订阅的事件code")
        private String eventCode;
        /**
         * 订阅者（流）code
         */
        @ApiModelProperty(value = "订阅者（流）code")
        private String flowCode;

        @ApiModelProperty(value = "订阅者（流）id")
        private String flowId;
        /**
         * 订阅者租户隔离编号
         */
        private String tenantCode;


        /**
         * 记录状态
         */
        @ApiModelProperty(value = "记录状态")
        private EditStatus status;

        /**
         * 是否启用
         */
        @ApiModelProperty(value = "是否启用")
        private String enable;
    }

    public static void main(String[] args) throws JsonProcessingException {
        EventSubscribeRequest eventSubscribeRequest = new EventSubscribeRequest();
        SubscribeRequest subscribeRequest = new SubscribeRequest();
        subscribeRequest.setAppId("appId");
        subscribeRequest.setEventId("eventId");
        subscribeRequest.setEventCode("eventCode");
        subscribeRequest.setFlowCode("flowCode");
        subscribeRequest.setTenantCode("tenantCode");
        subscribeRequest.setStatus(EditStatus.DELETE);
        subscribeRequest.setEnable("enable");
        eventSubscribeRequest.setSubscribeRequests(Lists.newArrayList(subscribeRequest));
        ObjectMapper objectMapper = new ObjectMapper();
        System.out.println(objectMapper.writeValueAsString(eventSubscribeRequest));
    }
}
