package com.xforceplus.ultraman.bocp.metadata.dto;

import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

/**
 * .
 *
 * @author leo
 * @version 0.1 2022/2/10 11:49 上午
 * @since 1.8
 */
public enum SourceType {
    /**
     * 来自节点上下文
     */
    NODE("node","节点输入输出"),

    /**
     * 来自变量
     */
    VARIABLE("variable","变量");




    @JsonValue
    private String value;

    private String description;

    SourceType(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String value() {
        return this.value;
    }

    public static SourceType fromValue(String value) {
        return Stream.of(SourceType.values())
            .filter(t -> t.value().equalsIgnoreCase(value))
            .findFirst().orElseThrow(() -> new RuntimeException("不存在的数据源类型！"));
    }
}
