package com.xforceplus.ultraman.bocp.metadata.dto;

import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoRelationType;
import com.xforceplus.ultraman.bocp.metadata.enums.*;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * Transition
 *
 * @author leo
 * @Description Transition
 * @date 2023/7/10
 **/
@Data
public class StateFlowDefinition {


    protected String code;

    protected String tenantCode;

    protected String version;
    protected String objectCode;
    private String name;
    private String stateField;
    private List<StateValue> states;
    private List<Transition> transitions;

    private FlowType type;


    @Data
    @NoArgsConstructor
    public static class StateValue {
        private String stateValueCode;
        private String stateValueName;
    }


    @Data
    @NoArgsConstructor
    public static class Transition {
        private String id;
        private String code;
        private String transitionName;
        private Integer transitionType;
        private String transitionConditionType;
        private String transitionConditionContent;
        private Integer transitionActionType;
        private String transitionActionContent;
        private String sourceStateValueCode;
        private String targetStateValueCode;
        private String transactionType;
        private List<TransitionEvent> transitionEvent;
    }

    @Data
    @NoArgsConstructor
    public static class TransitionEvent {
        private EventType eventType;
        private String eventCode;
        private EventDataHandlerType handlerType;
        private String handler;
        private StateFlowEventStage stage;
        private TriggerType triggerType;
        ConvertRule otherRule;
        ConvertRule inputRule;
        ConvertRule outputRule;
        private List<Relation> relations;
        private List<String> headFields;
    }

    @Data
    public static class Relation {
        private String relationCode;
        private BoRelationType relationDirection;
        private String relationBoId;
    }

}


