package com.xforceplus.ultraman.bocp.metadata.enums;

import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

/**
 * 项目名称: 票易通
 * JDK 版本: JDK1.8
 * 说明:
 * 作者(@author): liwei
 * 创建时间: 2021/1/12 8:25 PM
 */
public enum ActionType {

    /**
     * 本地调用下的SpringBean 方法调用
     */
    BEANMETHOD(1,"本地调用"),
    /**
     * Api调用
     */
    API(3,"API调用"),
    /**
     * 规则函数调用
     */
    EXPRESSION(2,"规则函数");


    @JsonValue
    private int value;

    private String description;

    ActionType(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    public Integer value() {
        return this.value;
    }

    public static ActionType fromValue(Integer value) {
        return Stream.of(ActionType.values())
                .filter(t -> t.value().equals(value))
                .findFirst().orElseThrow(() -> new RuntimeException("不存在Action类型！"));
    }

}
