package com.xforceplus.ultraman.bocp.metadata.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 9/22/2020 10:06 AM
 * @description:
 * @history:
 */
public enum AppType {
    //同步1.5
    @Deprecated
    CLOUD("cloud"),
    //同步2.0
    @Deprecated
    NEW_CLOUD("new-cloud"),
    LOCAL("local"),
    INTE_CLOUD("inte-cloud"),
    INTE_LOCAL("inte-local"),
    //应用多租户合并 + 同步1.5
    MULTI_TENANT_CLOUD("multi-tenant-cloud"),
    //应用多租户合并 + 同步2.0
    MULTI_TENANT_NEW_CLOUD("multi-tenant-new-cloud"),
    //系统
    SYS("sys");

    private String code;

    AppType(String code) {
        this.code = code;
    }

    public String code() {
        return code;
    }

    public static AppType fromCode(String code) {
        return Stream.of(AppType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(CLOUD);
    }

    /**
     * 同步2.0的类型列表
     * @return
     */
    public static List<String> getSync20TypeCodeList() {
        return Arrays.asList(NEW_CLOUD.code(), MULTI_TENANT_NEW_CLOUD.code());
    }

    public static List<String> getMultiTenantTypeCodeList() {
        return Arrays.asList(MULTI_TENANT_CLOUD.code(), MULTI_TENANT_NEW_CLOUD.code());
    }
}
