package com.xforceplus.ultraman.bocp.metadata.enums;

import java.util.stream.Stream;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 6/3/2021 1:59 PM
 * @description:
 * @history:
 */
public enum AppVersionType {
    /**
     * 小版本
     */
    SMALL("0", "小版本（缺陷修复，小功能调整）"),
    /**
     * 中版本
     */
    MEDIUM("1", "中版本（功能增强，保持兼容性的改动）"),

    /**
     * 大版本
     */
    BIG("2", "大版本（不保持兼容性）"),

    /**
     * 补丁
     */
    PATCH("3", "补丁");

    private String code;
    private String desc;

    AppVersionType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() {
        return desc;
    }

    @Override
    public String toString() {
        return desc + "(" + code + ")";
    }

    public static AppVersionType fromCode(String code) {
        return Stream.of(AppVersionType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
