package com.xforceplus.ultraman.bocp.metadata.enums;


/**
 * 对象字段的数据类型
 */
public enum DataValueType {
    OBJECT, STRING,STRINGS, LONG, BOOLEAN, LOCAL_DATE_TIME, DATE_TIME, BIG_DECIMAL, ENUM, STREAM,UNKNOWN,VOID,MAP;

    public static DataValueType getInstance(String name) {
        if (null != name) {
            switch (name.toLowerCase()) {
                case "object" :
                    return OBJECT;
                case "string" :
                    return STRING;
                case "strings" :
                    return STRINGS;
                case "long" :
                    return LONG;
                case "boolean" :
                    return BOOLEAN;
                case "local_date_time" :
                    return LOCAL_DATE_TIME;
                case "date_time" :
                    return DATE_TIME;
                case "big_decimal" :
                    return BIG_DECIMAL;
                case "enum" :
                    return ENUM;
                case "stream":
                    return STREAM;
                case "void":
                    return VOID;
                case "map":
                    return MAP;
                default:
                    return UNKNOWN;
            }

        }

        return UNKNOWN;
    }
    public static DataValueType codeToEnum(String code) {
        if (null != code) {
            switch (code.toLowerCase()) {
                case "string":
                    return STRING;
                case "object":
                    return OBJECT;
                case "short":
                case "integer":
                case "long":
                    return LONG;
                case "float":
                case "double":
                case "big_decimal":
                case "bigDecimal":
                    return BIG_DECIMAL;
                case "date-time":
                case "date_time":
                case "dateTime":
                    return DATE_TIME;
                case "local-date-time":
                case "local_date_time":
                case "localDateTime":
                    return LOCAL_DATE_TIME;
                case "boolean":
                    return BOOLEAN;
                case "enum":
                    return ENUM;
                case "map":
                    return MAP;
                default:
                    return UNKNOWN;
            }
        }
        return null;
    }
}
