package com.xforceplus.ultraman.bocp.metadata.enums;

import java.util.stream.Stream;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 7/2/2021 5:32 PM
 * @description:
 * @history:
 */
public enum EnvStatus {
    ENABLE("1", "启用"),
    DISABLE("0", "停用");

    String code;

    String desc;

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EnvStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnvStatus fromCode(String code) {
        return Stream.of(EnvStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
