package com.xforceplus.ultraman.bocp.metadata.enums;

import java.util.stream.Stream;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 7/2/2021 4:48 PM
 * @description:
 * @history:
 */
public enum EnvUseType {
    DEV("0", "开发环境"),
    TEST("1", "测试环境"),
    PROD("2", "生产环境");

    String code;

    String desc;

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EnvUseType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnvUseType fromCode(String code) {
        return Stream.of(EnvUseType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
