package com.xforceplus.ultraman.bocp.metadata.enums;

import java.util.stream.Stream;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/6/15 00:56
 * Description:
 * History:
 */
public enum NodeInfoStatus {
    OK("OK", "运行"),
    DOWN("DOWN", "下线");

    String code;

    String desc;

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NodeInfoStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static NodeInfoStatus fromCode(String code) {
        return Stream.of(NodeInfoStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
