package com.xforceplus.ultraman.bocp.metadata.enums;

import java.util.stream.Stream;

/**
 * 操作类型
 *
 * @className: FieldType
 * @package: com.xforceplus.ultraman.bocp.metadata.bo.enums.enums
 * @author: wangzheng
 * @date: 2021/3/4 17:39
 */
public enum OperatorEnum {
    UNKNOWN(""),
    LIKE("like"),
    EQUALS("eq"),
    NOT_EQUALS("ne"),
    GREATER_THAN("gt"),
    GREATER_THAN_EQUALS("ge"),
    LESS_THAN("lt"),
    LESS_THAN_EQUALS("le"),
    MULTIPLE_EQUALS("in");

    private String code;

    OperatorEnum(String code) {
        this.code = code;
    }

    public String code() {
        return code;
    }

    public static OperatorEnum getValue(String code) {
        return Stream.of(OperatorEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(UNKNOWN);
    }
}
