package com.xforceplus.ultraman.bocp.metadata.enums;

import java.util.stream.Stream;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   youyifan
 * 创建时间: 2/8/2020 4:14 PM
 * 功能描述:
 * 修改历史:
 */
public enum PublishFlag {

    /**
     * 未发布
     */
    UNPUBLISHED("0","未发布"),
    /**
     * 已发布
     */
    PUBLISHED("1","已发布");

    private String code;
    private String desc;

    PublishFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() {
        return desc;
    }

    @Override
    public String toString() {
        return desc + "(" + code + ")";
    }

    public static PublishFlag fromCode(String code) {
        return Stream.of(PublishFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
