package com.xforceplus.ultraman.bocp.metadata.enums;

import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 9/22/2020 10:06 AM
 * @description:
 * @history:
 */
public enum SupportFileType {
    UNKNOWN("unknown"),
    XLS("xls"),
    XLSX("xlsx"),
    XML("xml"),
    JSON("json");

    @JsonValue
    private String code;

    SupportFileType(String code) {
        this.code = code;
    }

    public String code() {
        return code;
    }

    public static SupportFileType fromCode(String code) {
        return Stream.of(SupportFileType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(UNKNOWN);
    }
}
