package com.xforceplus.ultraman.bocp.metadata.enums;

import java.util.stream.Stream;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 5/21/2021 4:05 PM
 * @description:
 * @history:
 */
public enum VersionStatus {

    /**
     * 测试版本
     */
    TEST("test", "测试版本"),
    /**
     * 正式版本
     */
    RELEASE("release", "正式版本");

    private String code;
    private String desc;

    VersionStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() {
        return desc;
    }

    @Override
    public String toString() {
        return desc + "(" + code + ")";
    }

    public static VersionStatus fromCode(String code) {
        return Stream.of(VersionStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
