
package com.xforceplus.ultraman.bocp.metadata.janus.dto;

import lombok.Data;

import java.util.List;
import java.util.stream.Stream;

@Data

public class JanusApiInfo {

    private String applicationName;

    private Boolean checkToken;

    private String contentType;

    private Object distributed;

    private String documentId;

    private Object env;

    private String eventType;

    private List<Object> groupIds;

    private String id;

    private String instanceId;

    private Object instanceType;

    private Long isValid;

    private Long maxLen;

    private Object mddlwareId;

    private String middlewareTopic;

    private String name;

    private Object preId;

    private String projectId;

    private String protocol;

    private String remark;

    private String requestMethod;

    private String requestPath;

    private String responseContentType;

    private String responsePath;

    private Long responseTime;

    private RestEntity restEntity;

    private String sourceType;

    private Boolean sync;

    private Long t;

    private String timeoutTips;
    private String creatorEmail;

    /**
     * 这个字段是手工添加的，不是接口返回的
     * 集成平台的action是放在列表里返回的，详情里面没有
     */
    private String action;


    @Data
    public static class RestEntity {


        private String id;

        private String preId;

        private String queryParams;

        private String requestBodyDesc;

        private String requestBodyExample;

        private String requestBodyExamples;

        private String requestHeaders;

        private String responseBody;

        private String responseBodyDesc;

        private String responseHeader;

        @Data
        public static class ParamAttribute {
            private String name;
            private Boolean required;
            private String defaultValue;
            private String len;
            private String desc;
            public String remark;
            public String remarkShow;
            public String enumType;
            public String id;
            public Object skipId;
            public Integer index;
        }

        @Data
        public static class BodyAttribute {
            private String id;
            private String parentId;
            private String name;
            private String type;
            private Integer mustFill;
            private String describe;
            private String refClassName;
            private String deValue;
            private String len;
            private String key;
            private String remark;
            private String remarkShow;
            private int index;
            private List<JanusApiInfo.RestEntity.BodyAttribute> children;

            public enum TypeEnum {
                STRING("String"),
                NUMBER("Number"),
                BOOLEAN("Boolean"),
                OBJECT("Object"),
                MAP("Map"),
                ARRAY("Array");
                private String code;

                TypeEnum(String code) {
                    this.code = code;
                }

                public String getCode() {
                    return code;
                }

                public static TypeEnum fromCode(String code) {
                    return Stream.of(TypeEnum.values())
                            .filter(t -> t.getCode().equals(code))
                            .findFirst().orElseThrow(() -> new RuntimeException("未知的类型"));
                }
            }
        }
    }


}
