package com.xforceplus.ultraman.bocp.metadata.mapstruct;

import com.xforceplus.ultraman.bocp.mybatisplus.entity.Apis;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 9/9/2020 11:13 AM
 * @description:
 * @history:
 */
@Mapper(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
public interface ApisStructMapper {

    ApisStructMapper MAPPER = Mappers.getMapper(ApisStructMapper.class);

    Apis clone(Apis obj);

    void updateEntity(Apis obj, @MappingTarget Apis newObj);

    @BeanMapping(ignoreByDefault = true)
    @Mapping(source = "apiType", target = "apiType")
    @Mapping(source = "apiServiceCode", target = "apiServiceCode")
    @Mapping(source = "apiCode", target = "apiCode")
    @Mapping(source = "apiDesc", target = "apiDesc")
    @Mapping(source = "url", target = "url")
    @Mapping(source = "retries", target = "retries")
    @Mapping(source = "method", target = "method")
    @Mapping(source = "requestMediaType", target = "requestMediaType")
    @Mapping(source = "requestPathVariables", target = "requestPathVariables")
    @Mapping(source = "requestParameters", target = "requestParameters")
    @Mapping(source = "requestHeaders", target = "requestHeaders")
    @Mapping(source = "requestArrayBody", target = "requestArrayBody")
    @Mapping(source = "requestBody", target = "requestBody")
    @Mapping(source = "requestDateFormat", target = "requestDateFormat")
    @Mapping(source = "responseMediaType", target = "responseMediaType")
    @Mapping(source = "responseArrayBody", target = "responseArrayBody")
    @Mapping(source = "responseBody", target = "responseBody")
    @Mapping(source = "responseDateFormat", target = "responseDateFormat")
    @Mapping(source = "discard", target = "discard")
    @Mapping(source = "templateCode", target = "templateCode")
    void update(Apis obj, @MappingTarget Apis newObj);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(source = "apiType", target = "apiType")
    @Mapping(source = "apiServiceCode", target = "apiServiceCode")
    @Mapping(source = "apiCode", target = "apiCode")
    @Mapping(source = "apiDesc", target = "apiDesc")
    @Mapping(source = "apiVersion", target = "apiVersion")
    @Mapping(source = "url", target = "url")
    @Mapping(source = "retries", target = "retries")
    @Mapping(source = "method", target = "method")
    @Mapping(source = "requestMediaType", target = "requestMediaType")
    @Mapping(source = "requestPathVariables", target = "requestPathVariables")
    @Mapping(source = "requestParameters", target = "requestParameters")
    @Mapping(source = "requestHeaders", target = "requestHeaders")
    @Mapping(source = "requestArrayBody", target = "requestArrayBody")
    @Mapping(source = "requestBody", target = "requestBody")
    @Mapping(source = "requestDateFormat", target = "requestDateFormat")
    @Mapping(source = "responseMediaType", target = "responseMediaType")
    @Mapping(source = "responseHeaders", target = "responseHeaders")
    @Mapping(source = "responseArrayBody", target = "responseArrayBody")
    @Mapping(source = "responseBody", target = "responseBody")
    @Mapping(source = "responseDateFormat", target = "responseDateFormat")
    @Mapping(source = "discard", target = "discard")
    @Mapping(source = "templateCode", target = "templateCode")
    @Mapping(source = "templateContent", target = "templateContent")
    @Mapping(target = "version", source = "version")
    void recover(Apis vEntity, @MappingTarget Apis currentEntity);
}
