package com.xforceplus.ultraman.bocp.metadata.mapstruct;

import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.metadata.vo.DictVo;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 9/9/2020 11:13 AM
 * @description:
 * @history:
 */
@Mapper(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
public interface DictStructMapper {
    DictStructMapper MAPPER = Mappers.getMapper(DictStructMapper.class);

    DictVo toVo(Dict dict);

    Dict toEntity(DictVo dictVo);

    Dict clone(Dict dict);

    void updateEntity(Dict newDict, @MappingTarget Dict dict);

    void updateEntityFromVo(DictVo dictVo, @MappingTarget Dict dict);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(source = "name", target = "name")
    @Mapping(source = "code", target = "code")
    @Mapping(source = "remark", target = "remark")
    void updateUDictFromSysDict(Dict sys, @MappingTarget Dict dict);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "uniqueId", ignore = true)
    @Mapping(target = "publishDictId", ignore = true)
    @Mapping(target = "publishFlag", expression = "java(\"0\")")
    @Mapping(target = "version", expression = "java(\"0.0.0\")")
    @Mapping(target = "createUser", ignore = true)
    @Mapping(target = "createUserName", ignore = true)
    @Mapping(target = "createTime", ignore = true)
    @Mapping(target = "updateUser", ignore = true)
    @Mapping(target = "updateUserName", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    Dict createUDictFromSysDict(Dict o);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(source = "name", target = "name")
    @Mapping(source = "code", target = "code")
    @Mapping(source = "remark", target = "remark")
    @Mapping(source = "version", target = "version")
    void recover(Dict vEntity, @MappingTarget Dict currentEntity);
}
