package com.xforceplus.ultraman.bocp.metadata.mapstruct;

import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueRule;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 9/9/2020 11:13 AM
 * @description:
 * @history:
 */
@Mapper(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
public interface SueRuleStructMapper {

    SueRuleStructMapper MAPPER = Mappers.getMapper(SueRuleStructMapper.class);

    SueRule clone(SueRule obj);

    void updateEntity(SueRule obj, @MappingTarget SueRule newObj);

    @BeanMapping(ignoreByDefault = true)
    @Mapping(source = "ruleCode", target = "ruleCode")
    @Mapping(source = "ruleName", target = "ruleName")
    @Mapping(source = "ruleContent", target = "ruleContent")
    @Mapping(source = "ruleCondition", target = "ruleCondition")
    @Mapping(source = "ruleMsg", target = "ruleMsg")
    @Mapping(source = "rulePassedMsg", target = "rulePassedMsg")
    @Mapping(source = "paramObjectCode", target = "paramObjectCode")
    @Mapping(source = "ruleType", target = "ruleType")
    @Mapping(source = "status", target = "status")
    @Mapping(source = "tagCode", target = "tagCode")
    void update(SueRule obj, @MappingTarget SueRule newObj);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(source = "ruleCode", target = "ruleCode")
    @Mapping(source = "ruleName", target = "ruleName")
    @Mapping(source = "ruleContent", target = "ruleContent")
    @Mapping(source = "ruleCondition", target = "ruleCondition")
    @Mapping(source = "ruleMsg", target = "ruleMsg")
    @Mapping(source = "rulePassedMsg", target = "rulePassedMsg")
    @Mapping(source = "paramObjectCode", target = "paramObjectCode")
    @Mapping(source = "ruleType", target = "ruleType")
    @Mapping(source = "status", target = "status")
    @Mapping(source = "tagCode", target = "tagCode")
    @Mapping(source = "version", target = "version")
    void recover(SueRule vEntity, @MappingTarget SueRule currentEntity);
}
