package com.xforceplus.ultraman.bocp.metadata.rule.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 项目名称: 票易通
 * JDK 版本: JDK1.8
 * 说明:
 * 作者(@author): liwei
 * 创建时间: 2020/5/26 11:45 AM
 */
@Data
@ApiModel(value = "RuleAddRequest",description = "新增规则结构体")
public class RuleAddRequest {


    /**
     * 规则编码
     */
    @ApiModelProperty(value = "规则编码",required=true)
    private String ruleCode;

    /**
     * 规则名称
     */
    @ApiModelProperty(value = "规则名称",required=true)
    private String ruleName;

    /**
     * 规则内容
     */
    @ApiModelProperty(value = "规则内容",required=true)
    private String ruleContent;

    /**
     * 规则条件
     */
    @ApiModelProperty(value = "规则条件",required = false)
    private String ruleCondition;

    /**
     * 规则描述
     */
    @ApiModelProperty(value = "规则描述",required = false)
    private String ruleDesc;

    /**
     * 规则警示消息内容
     */
    @ApiModelProperty(value = "规则警示消息内容",required = false)
    private String ruleMsg;



    /**
     * 规则警示消息内容
     */
    @ApiModelProperty(value = "规则通过后的消息展示",required = false)
    private String rulePassedMsg;

    /**
     * 1:启用 0：不启用
     */
    @ApiModelProperty(value = "是否启用",required = false)
    private Integer enabled;

    /**
     * 应用ID
     */
    @ApiModelProperty(value = "应用ID",required = true)
    private String appId;


    /**
     * 规则主键
     */
    @ApiModelProperty(value = "ruleId主键,更新时需传入",required = false)
    private Long ruleId;


    /**
     * tag编码
     */
    @ApiModelProperty(value = "tag编码",required = false)
    private String tagCode;

    /**
     * 规则绑定的元数据对象
     */
    @ApiModelProperty(value = "元数据对象标识，如：code:version ",required = true)
    private String paramObjectCode;

}
