package com.xforceplus.ultraman.bocp.metadata.validator;

import lombok.Data;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/12/10 23:37
 * Description:
 * History:
 */
@Data
public class ValidateResponse<T> {

    public ValidateResponse(boolean success, String message) {
        this.success = success;
        this.message = message;
    }

    public ValidateResponse(boolean success, String message, T data) {
        this.success = success;
        this.message = message;
        this.data = data;
    }

    boolean success;
    String message;

    T data;

    public static ValidateResponse success() {
        return new ValidateResponse(true, null);
    }

    public static ValidateResponse success(Object data) {
        return new ValidateResponse(true, null, data);
    }

    public static ValidateResponse failed(String message) {
        return new ValidateResponse(false, message);
    }

    public boolean failed() {
        return this.success == false;
    }
}
