package com.xforceplus.ultraman.bocp.metadata.apis.enums;


public enum ApiType {

    USER("user"),
    METADATA("metadata"),
    AUTOFLOW("autoflow"),
    SERVICE("service"),
    JANUS("janus"),
    USERCENTER("usercenter"),
    // 兼容预留
    SYSTEM("sys");
    private String value;

    ApiType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static ApiType fromValue(String value) {
        if (null != value) {
            for (ApiType mt : ApiType.values()) {
                if (mt.getValue().equalsIgnoreCase(value)) {
                    return mt;
                }
            }
        }
        return null;
    }

}
