package com.xforceplus.ultraman.bocp.metadata.apis.enums;


/**
 * desc :
 * name : MediaType
 *
 * @author : xujia
 * date : 2020/5/7
 * @since : 1.8
 */
public enum MediaType {

    TEXT("text/plain"),
    STREAMS("octet-stream"),
    JSON("application/json"),
    PROTO_BUF("application/x-protobuf"),
    XML("application/xml"),
    FORM("application/x-www-form-urlencoded"),
    UN_KNOWN("unknown");

    private String value;

    MediaType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static MediaType valueToEnum(String value) {
        if (null != value) {
            for (MediaType mt : MediaType.values()) {
                if (mt.getValue().equalsIgnoreCase(value)) {
                    return mt;
                }
            }
        }
        return null;
    }

    public static MediaType nameToEnum(String value) {
        if (null != value) {
            for (MediaType mt : MediaType.values()) {
                if (mt.name().equalsIgnoreCase(value)) {
                    return mt;
                }
            }
        }
        return null;
    }
}
