package com.xforceplus.ultraman.bocp.metadata.apis.pojo;

import com.xplat.ultraman.api.management.pojo.enums.Method;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * desc :
 * name : ApiBaseInfoDto
 *
 * @author : xujia
 * date : 2020/5/12
 * @since : 1.8
 */
@Data
public class ApiBasic {

    /**
     * api的唯一ID标示.
     */
    protected String id;

    /**
     * 所属应用.
     */
    protected String applicationId;

    /**
     * 注明该api在代码自动生成时所该归集到哪个service中.
     */
    protected String serviceCode;
    protected String apiServiceCode;

    /**
     * 应用内保持唯一.
     */
    protected String apiCode;

    protected String apiType;

    /**
     * api的中文描述.
     */
    protected String apiDescription;
    protected String apiDesc;

    /**
     * api版本.
     */
    protected Integer apiVersion;

    /**
     * 重试次数, 默认为0.
     */
    protected Integer retries;

    /**
     * api的url.
     */
    protected String url;

    /**
     * 请求类型.
     */
    protected Method method;

    /**
     * 废弃标志
     */
    protected boolean discard;

    /**
     * 创建者.
     */
    protected String createUserName;

    /**
     * 修改人.
     */
    protected String updateUserName;


    /**
     * 模版code
     */
    protected String templateCode;

    /**
     * 来源ID
     */
    protected Long sourceId;

    protected LocalDateTime updateTime;
    protected LocalDateTime createTime;
}
