package com.xforceplus.ultraman.bocp.metadata.bo.enums;

import java.util.stream.Stream;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: wangzheng
 * @createTime: 3/17/2021 6:46 PM
 * @description:
 * @history:
 */
public enum AggregationType {
    UNKNOWN("0", "未知"),
    /** * 总数 */
    COUNT("1", "总数"),
    /** * 求和 */
    SUM("2", "求和"),
    /** * 平均值 */
    AVG("3", "平均值"),
    /** * 最小 */
    MIN("4", "最小"),
    /** * 最大 */
    MAX("5", "最大"),
    /** * 集合 */
    COLLECT("6", "集合");

    private String code;

    private String desc;

    AggregationType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() { return desc; }

    public static AggregationType fromCode(String code) {
        return Stream.of(AggregationType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
