package com.xforceplus.ultraman.bocp.metadata.bo.enums;

import java.util.stream.Stream;

public enum BoApiAbility {
    QUERY("query", "查询列表"),
    QUERY_ONE("queryOne", "单个查询"),
    CREATE("create", "创建"),
    UPDATE("update", "更新"),
    DELETE("delete", "删除"),
    IMPORT("import", "导入"),
    EXPORT("export", "导出"),
    IMPORT_TEMPLATE("importTemplate", "导入模版"),
    BATCH_CREATE("batchCreate", "批量新增"),
    BATCH_UPDATE("batchUpdate", "批量更新"),
    BATCH_DELETE("batchDelete", "批量删除"),
    CREATE_WITH_DETAILS("createWithDetails", "批量创建带明细"),
    GRAPHQL("graphql", "graphql"),
    STATISTICS("statistics", "统计"),
    ;

    private String code;

    private String desc;

    BoApiAbility(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() {
        return desc;
    }

    public static BoApiAbility fromCode(String code) {
        return Stream.of(BoApiAbility.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElseThrow(() -> new RuntimeException("不存在BoApiAbility类型！"));
    }
}
