package com.xforceplus.ultraman.bocp.metadata.bo.enums;

import java.util.stream.Stream;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/12/9 16:22
 * Description: 主键规则
 * History:
 */
public enum BoIndexRuleType {

    STRICT("0", "同时新增多个数据时，若存在主键校验不通过的重复数据，则：同一批次内，所有数据均不能落表"),
    LOOSE("1", "同时新增多个数据时，若存在主键校验不通过的重复数据，则：同一批次内，通过主键校验的数据可以落表");

    private String code;

    private String desc;

    BoIndexRuleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public static BoIndexRuleType fromCode(String code) {
        return Stream.of(BoIndexRuleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
