package com.xforceplus.ultraman.bocp.metadata.bo.enums;

import java.util.stream.Stream;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/1/5 12:01
 * Description:
 * History:
 */
public enum BoOperate {

    CREATE("create", "新建"),
    UPDATE("update", "更新"),
    EXTEND("extend", "继承"),
    COPY("copy", "复制"),
    DISPLAY("display", "显示"),
    SYNC("sync", "同步");

    private String code;

    private String desc;

    BoOperate(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() { return desc; }

    public static BoOperate fromCode(String code) {
        return Stream.of(BoOperate.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
