package com.xforceplus.ultraman.bocp.metadata.bo.enums;

import java.util.stream.Stream;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 3/17/2021 6:46 PM
 * @description:
 * @history:
 */
public enum FuzzyType {
    UNKNOWN("0", "默认"),
    /** * 不作处理 */
    NOT("1", "精确匹配"),
    /** * 通配符 */
    WILDCARD("2", "模糊匹配（通配符）"),
    /** * 分词 */
    SEGMENTATION("3", "模糊匹配（分词）");

    private String code;

    private String desc;

    FuzzyType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() { return desc; }

    public static FuzzyType fromCode(String code) {
        return Stream.of(FuzzyType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
