package com.xforceplus.ultraman.bocp.metadata.bo.mapstruct;

import com.xforceplus.ultraman.bocp.metadata.bo.dto.BoApiInfoDTO;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoApi;
import com.xforceplus.ultraman.bocp.metadata.vo.BoApiVo;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 9/9/2020 11:28 AM
 * @description:
 * @history:
 */
@Mapper(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
public interface BoApiStructMapper {
    BoApiStructMapper MAPPER = Mappers.getMapper(BoApiStructMapper.class);

    BoApi toEntity(BoApiVo boApiVo);

//    BoApi toEntity(Map<String,Object> mApi);
//
//    BoApiVo toVo(Map<String,Object> mApi);

    BoApiVo toVo(BoApi boApi);

    BoApi clone(BoApi boApi);

    void updateEntity(BoApi newBoApi, @MappingTarget BoApi boApi);

    void updateEntityFromVo(BoApiVo boApiVo, @MappingTarget BoApi boApi);

    @BeanMapping(ignoreByDefault = true)
    @Mapping(source = "id", target = "id")
    @Mapping(source = "method", target = "method")
    @Mapping(source = "url", target = "url")
    @Mapping(source = "externalUrl", target = "externalUrl")
    @Mapping(source = "apiId", target = "apiId")
    @Mapping(source = "apiType", target = "apiType")
    @Mapping(source = "apiVersion", target = "apiVersion")
    @Mapping(source = "apiSourceAppId", target = "apiSourceAppId")
    @Mapping(source = "code", target = "code")
    @Mapping(source = "name", target = "name")
    @Mapping(source = "params", target = "params")
    @Mapping(source = "requestData", target = "requestData")
    @Mapping(source = "requestHeader", target = "requestHeader")
    @Mapping(source = "responseData", target = "responseData")
    @Mapping(source = "customCode", target = "customCode")
    BoApiInfoDTO toBoApiInfoDTO(BoApi boApi);

    @BeanMapping(ignoreByDefault = true)
    @Mapping(source = "id", target = "id")
    @Mapping(source = "method", target = "method")
    @Mapping(source = "url", target = "url")
    @Mapping(source = "externalUrl", target = "externalUrl")
    @Mapping(source = "apiId", target = "apiId")
    @Mapping(source = "apiType", target = "apiType")
    @Mapping(source = "apiVersion", target = "apiVersion")
    @Mapping(source = "apiSourceAppId", target = "apiSourceAppId")
    @Mapping(source = "code", target = "code")
    @Mapping(source = "name", target = "name")
    @Mapping(source = "params", target = "params")
    @Mapping(source = "requestData", target = "requestData")
    @Mapping(source = "requestHeader", target = "requestHeader")
    @Mapping(source = "responseData", target = "responseData")
    @Mapping(source = "customCode", target = "customCode")
    BoApi boApiInfoDTOToEntity(BoApiInfoDTO boApi);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(target = "apiType", source = "apiType")
    @Mapping(target = "endpointId", source = "endpointId")
    @Mapping(target = "name", source = "name")
    @Mapping(target = "code", source = "code")
    @Mapping(target = "customCode", source = "customCode")
    @Mapping(target = "method", source = "method")
    @Mapping(target = "url", source = "url")
    @Mapping(target = "params", source = "params")
    @Mapping(target = "responseData", source = "responseData")
    @Mapping(target = "apiId", source = "apiId")
    @Mapping(target = "apiVersion", source = "apiVersion")
    @Mapping(target = "apiSourceAppId", source = "apiSourceAppId")
    @Mapping(target = "requestData", source = "requestData")
    @Mapping(target = "requestHeader", source = "requestHeader")
    @Mapping(target = "authCode", source = "authCode")
    @Mapping(target = "externalUrl", source = "externalUrl")
    void recover(BoApi vEntity, @MappingTarget BoApi currentEntity);
}
