package com.xforceplus.ultraman.bocp.metadata.bo.mapstruct;

import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.metadata.val.TypeVal;
import com.xforceplus.ultraman.bocp.metadata.vo.BoFieldVo;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 9/9/2020 11:27 AM
 * @description:
 * @history:
 */
@Mapper(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
public interface BoFieldStructMapper {
    BoFieldStructMapper MAPPER = Mappers.getMapper(BoFieldStructMapper.class);

    @Mapping(source="fieldType", target="type")
    @Mapping(source="arrayType", target="isArray", qualifiedByName = "typeToBool")
    @Mapping(source="dynamicType", target="dynamic", qualifiedByName = "typeToBool")
    BoFieldVo toVo(BoField boField);

    @Mapping(source="type", target="fieldType")
    BoField toEntity(BoFieldVo boFieldVo);

    BoField clone(BoField boField);

    BoFieldVo cloneVo(BoFieldVo boFieldVo);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "uniqueId", ignore = true)
    @Mapping(target = "publishFieldId", ignore = true)
    @Mapping(target = "publishFlag", expression = "java(\"0\")")
    @Mapping(target = "createUser", ignore = true)
    @Mapping(target = "createUserName", ignore = true)
    @Mapping(target = "createTime", ignore = true)
    @Mapping(target = "updateUser", ignore = true)
    @Mapping(target = "updateUserName", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    BoField createUBoFieldFromSysBoField(BoField boField);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(target = "alias", source = "alias")
    @Mapping(target = "title", source = "title")
    @Mapping(target = "arrayType", source = "arrayType")
    @Mapping(target = "fieldType", source = "fieldType")
    @Mapping(target = "dictId", source = "dictId")
    @Mapping(target = "niKey", source = "niKey")
    @Mapping(target = "fieldKey", source = "fieldKey")
    @Mapping(target = "defaultValue", source = "defaultValue")
    @Mapping(target = "sortPlace", source = "sortPlace")
    @Mapping(target = "tips", source = "tips")
    @Mapping(target = "remark", source = "remark")
    @Mapping(target = "status", source = "status")
    @Mapping(target = "dynamicType", source = "dynamicType")
    @Mapping(target = "sysType", source = "sysType")
    void updateUBoFieldFromSysBoField(BoField sys, @MappingTarget BoField currentEntity);


    @Mapping(source="type", target="fieldType")
    @Mapping(source="isArray", target="arrayType", qualifiedByName = "boolToType")
    @Mapping(source="dynamic", target="dynamicType", qualifiedByName = "boolToType")
    @Mapping(source="defaultValue", target="defaultValue", nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.SET_TO_NULL)
    void updateEntityFromVo(BoFieldVo boFieldVo, @MappingTarget BoField boField);

    void updateEntity(BoField newBoField, @MappingTarget BoField boField);

    @Named("boolToType")
    default String boolToType(Boolean bool) {
        return bool != null && bool ? "1" : "0";
    }

    @Named("typeToBool")
    default Boolean typeToBool(String type) {
        return TypeVal.BOOL_TRUE.equals(type);
    }

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "uniqueId", ignore = true)
    @Mapping(target = "uniqueName", ignore = true)
    @Mapping(target = "tenantCode", ignore = true)
    @Mapping(target = "boId", ignore = true)
    @Mapping(target = "fieldId", ignore = true)
    @Mapping(target = "syncFieldId", ignore = true)
    @Mapping(target = "publishFieldId", ignore = true)
    @Mapping(target = "publishFlag", ignore = true)
    @Mapping(target = "createUser", ignore = true)
    @Mapping(target = "createUserName", ignore = true)
    @Mapping(target = "createTime", ignore = true)
    @Mapping(target = "updateUser", ignore = true)
    @Mapping(target = "updateUserName", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "deleteFlag", ignore = true)
    void sync(BoField boField, @MappingTarget BoField syncBoField);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(target = "name", source = "name")
    @Mapping(target = "code", source = "code")
    @Mapping(target = "alias", source = "alias")
    @Mapping(target = "title", source = "title")
    @Mapping(target = "arrayType", source = "arrayType")
    @Mapping(target = "fieldType", source = "fieldType")
    @Mapping(target = "dictId", source = "dictId")
    @Mapping(target = "niKey", source = "niKey")
    @Mapping(target = "fieldKey", source = "fieldKey")
    @Mapping(target = "defaultValue", source = "defaultValue")
    @Mapping(target = "sortPlace", source = "sortPlace")
    @Mapping(target = "tips", source = "tips")
    @Mapping(target = "remark", source = "remark")
    @Mapping(target = "status", source = "status")
    @Mapping(target = "dynamicType", source = "dynamicType")
    @Mapping(target = "sysType", source = "sysType")
    void recover(BoField vEntity, @MappingTarget BoField currentEntity);

}
