package com.xforceplus.ultraman.bocp.metadata.bo.mapstruct;

import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoErVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoEx;
import com.xforceplus.ultraman.bocp.metadata.vo.BoInfoVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoSimpleVo;
import com.xforceplus.ultraman.bocp.metadata.vo.external.BoInfoExt;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 9/9/2020 11:23 AM
 * @description:
 * @history:
 */
@Mapper(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
public interface BoStructMapper {
    BoStructMapper MAPPER = Mappers.getMapper(BoStructMapper.class);

    BoInfoVo toInfoVo(Bo bo);

    Bo toEntity(BoInfoVo boInfoVo);

    Bo clone(Bo bo);

    BoInfoVo cloneVo(BoInfoVo boInfoVo);

    BoEx toBoEx(Bo bo);

    BoErVo toBoErVo(Bo bo);

    BoSimpleVo toBoSimpleVo(Bo bo);

    BoInfoExt toBoInfoExt(BoInfoVo boInfoVo);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "uniqueId", ignore = true)
    @Mapping(target = "publishBoId", ignore = true)
    @Mapping(target = "publishFlag", expression = "java(\"0\")")
    @Mapping(target = "version", expression = "java(\"0.0.0\")")
    @Mapping(target = "createUser", ignore = true)
    @Mapping(target = "createUserName", ignore = true)
    @Mapping(target = "createTime", ignore = true)
    @Mapping(target = "updateUser", ignore = true)
    @Mapping(target = "updateUserName", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    Bo createUBoFromSysBo(Bo bo);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(source = "name", target = "name")
    @Mapping(source = "code", target = "code")
    @Mapping(source = "alias", target = "alias")
    @Mapping(source = "title", target = "title")
    @Mapping(source = "remark", target = "remark")
    @Mapping(source = "status", target = "status")
    void updateUBoFromSysBo(Bo sys, @MappingTarget Bo bo);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "uniqueId", ignore = true)
    @Mapping(target = "appId", ignore = true)
    @Mapping(target = "refBoId", ignore = true)
    @Mapping(target = "parentBoId", ignore = true)
    @Mapping(target = "syncBoId", ignore = true)
//    @Mapping(target = "code", ignore = true)
    @Mapping(target = "level", ignore = true)
    @Mapping(target = "boType", ignore = true)
    @Mapping(target = "createType", ignore = true)
    @Mapping(target = "sysType", ignore = true)
    @Mapping(target = "customType", ignore = true)
    @Mapping(target = "publishFlag", ignore = true)
    @Mapping(target = "publishBoId", ignore = true)
//    @Mapping(target = "status", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "tenantName", ignore = true)
    @Mapping(target = "tenantCode", ignore = true)
    @Mapping(target = "createUser", ignore = true)
    @Mapping(target = "createUserName", ignore = true)
    @Mapping(target = "createTime", ignore = true)
    @Mapping(target = "updateUser", ignore = true)
    @Mapping(target = "updateUserName", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "deleteFlag", ignore = true)
    void updateEntity(Bo newBo, @MappingTarget Bo bo);

    void updateEntityFromVo(BoInfoVo boInfoVo, @MappingTarget Bo bo);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(source = "name", target = "name")
    @Mapping(source = "code", target = "code")
    @Mapping(source = "alias", target = "alias")
    @Mapping(source = "title", target = "title")
    @Mapping(source = "boType", target = "boType")
    @Mapping(source = "remark", target = "remark")
    @Mapping(source = "version", target = "version")
    @Mapping(source = "status", target = "status")
    void recover(Bo vBo, @MappingTarget Bo currentBo);
}
