package com.xforceplus.ultraman.bocp.metadata.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;

import java.io.IOException;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/6/5 11:20
 * Description:
 * History:
 */
public class JsonToStringDeserializer extends JsonDeserializer<String> {

    @Override
    public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if(null == jsonParser) {
            return null;
        }
        JsonNode node = jsonParser.getCodec().readTree(jsonParser);
        if(null == node) {
            return null;
        }
        return node.toString();
    }

}
