package com.xforceplus.ultraman.bocp.metadata.dto;

import com.xforceplus.ultraman.bocp.metadata.enums.DeployStatus;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/8/24 12:55
 * Description:
 * History:
 */
@Data
public class AppDeployDTO {
    private MetadataType metadataType;
    private AppCustomType customType;
    private Long appId;
    private Long envId;
    private String deployVersion;
    private DeployStatus deployStatus;
    private Long deployerId;
    private String deployerName;
    private LocalDateTime deployTime;

    public AppDeployDTO(MetadataType metadataType, Long appId, Long envId, String deployVersion, DeployStatus deployStatus) {
        this.metadataType = metadataType;
        this.appId = appId;
        this.envId = envId;
        this.deployVersion = deployVersion;
        this.deployStatus = deployStatus;
    }

    public AppDeployDTO(AppCustomType customType, Long appId, Long envId,
                        String deployVersion, Long deployerId, String deployerName, LocalDateTime deployTime) {
        this.customType = customType;
        this.appId = appId;
        this.envId = envId;
        this.deployVersion = deployVersion;
        this.deployerId = deployerId;
        this.deployerName = deployerName;
        this.deployTime = deployTime;
    }
}
