package com.xforceplus.ultraman.bocp.metadata.dto;

import lombok.Data;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   youyifan
 * 创建时间: 2/5/2020 4:47 PM
 * 功能描述:
 * 修改历史:
 */
@Data
public class ServiceResponse<T> {
    public static String SUCCESS_CODE = "1";
    public static String FAIL_CODE = "0";

    String code;
    String message;
    T data;

    public ServiceResponse(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public ServiceResponse(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static <T> ServiceResponse<T> success(){
        return new ServiceResponse<T>(SUCCESS_CODE, "");
    }

    public static <T> ServiceResponse<T> success(String message){
        return new ServiceResponse<T>(SUCCESS_CODE, message);
    }

    public static <T> ServiceResponse<T> success(String message, T data){
        return new ServiceResponse<T>(SUCCESS_CODE, message, data);
    }

    public static <T> ServiceResponse<T> fail(String message){
        return new ServiceResponse<T>(FAIL_CODE, message);
    }

    public boolean isSuccess(){
        return SUCCESS_CODE.equals(this.code);
    }

    public static <T> ServiceResponse<T> fail(String message, T data){
        return new ServiceResponse<T>(FAIL_CODE, message, data);
    }
}
