package com.xforceplus.ultraman.bocp.metadata.dto;

import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

/**
 * .
 *
 * @author leo
 * @version 0.1 2022/2/10 3:07 下午
 * @since 1.8
 */
public enum ValueType {
    /**
     * 输入值
     */
    LITERAL("literal","输入值"),
    /**
     * 单数据源下的字段名
     */
    PROCESS_VAR("processVar","单数据源下的字段名"),
    /**
     * 公式表达式
     */
    EXPRESSION("expression","公式表达式"),



    SOURCE("source","数据源类型"),

    /**
     * 局部变量或者全局变量
     */
    VARIABE("variable","流程变量"),

    /**
     * 系统字段
     */
    SYSTEM_FIELD("systemField","系统字段");


    @JsonValue
    private String value;

    private String description;

    ValueType(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String value() {
        return this.value;
    }

    public static ValueType fromValue(Integer value) {
        return Stream.of(ValueType.values())
            .filter(t -> t.value().equals(value))
            .findFirst().orElseThrow(() -> new RuntimeException("不存在valueType类型！"));
    }
}
