package com.xforceplus.ultraman.bocp.metadata.entity;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.enums.DataValueType;

import java.util.Map;

/**
 * 对象字段格式定义.
 *
 * @author leo
 * @version 0.1 2022/3/10 11:33 上午
 * @since 1.8
 */
public class JsonSchema {

    private DataValueType type;
    private Boolean array = false;
    private Boolean map = false;
    private Map<String, JsonSchema> properties;
    private String description;
    private String sheetName;
    private Integer sheetIndex;
    private Integer headIndex;


    public JsonSchema() {
        this.properties = Maps.newHashMap();
    }

    public JsonSchema(Map<String,JsonSchema> properties) {
        this.properties = properties;
    }

    public DataValueType getType() {
        return type;
    }

    public void setType(DataValueType type) {
        this.type = type;
    }

    public Boolean isArray() {
        return array;
    }

    public void setArray(Boolean array) {
        this.array = array;
    }

    public Map<String, JsonSchema> getProperties() {
        return properties;
    }

    public void setProperties(Map<String, JsonSchema> properties) {
        this.properties = properties;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean isMap() {
        return map;
    }

    public void setMap(Boolean map) {
        this.map = map;
    }

    public String getSheetName() {
        return sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public Integer getSheetIndex() {
        return sheetIndex;
    }

    public void setSheetIndex(Integer sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    public Integer getHeadIndex() {
        return headIndex;
    }

    public void setHeadIndex(Integer headIndex) {
        this.headIndex = headIndex;
    }

}
