package com.xforceplus.ultraman.bocp.metadata.enums;

import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

/**
 * .
 *
 * @author leo
 * @version 0.1 2022/2/10 11:49 上午
 * @since 1.8
 */
public enum ConditionType {

    /**
     * 脚本条件
     */
    EXPRESSION("expression","脚本条件"),

    /**
     * condition条件
     */
    NORMAL("normal","普通条件"),


    /**
     * Action条件
     */
    AUTOMAITC_FLOW("automatic_flow","自动化流输出"),

    /**
     * Action 条件
     */
    ACTION("action","自定义action");



    @JsonValue
    private String value;

    private String description;

    ConditionType(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String value() {
        return this.value;
    }

    public static ConditionType fromValue(String value) {
        return Stream.of(ConditionType.values())
            .filter(t -> t.value().equals(value))
            .findFirst().orElseThrow(() -> new RuntimeException("不存在的条件类型！"));
    }
}
