package com.xforceplus.ultraman.bocp.metadata.enums;

import java.util.stream.Stream;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 7/2/2021 4:48 PM
 * @description:
 * @history:
 */
public enum EnvCreateType {
    SYS("0", "系统"),
    CUSTOM("1", "自定义");

    String code;

    String desc;

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EnvCreateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnvCreateType fromCode(String code) {
        return Stream.of(EnvCreateType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
