package com.xforceplus.ultraman.bocp.metadata.enums;

import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

/**
 * .
 *
 * @author leo
 * @version 0.1 2022/2/10 11:49 上午
 * @since 1.8
 */
public enum EventDataHandlerType {


    DEFAULT("default","默认事件内容处理器"),



    AUTOMAITC_FLOW("automatic_flow","自动化流处理器"),

    /**
     * Action 条件
     */
    ACTION("action","自定义Action处理器");






    @JsonValue
    private String value;

    private String description;

    EventDataHandlerType(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String value() {
        return this.value;
    }

    public static EventDataHandlerType fromValue(String value) {
        return Stream.of(EventDataHandlerType.values())
            .filter(t -> t.value().equals(value))
            .findFirst().orElseThrow(() -> new RuntimeException("不存在的条件类型！"));
    }
}
